<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Berhasil Dibuat</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@10/dist/sweetalert2.min.css">

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            /* Background Serasi */
            background: linear-gradient(rgba(0, 0, 0, 0.6), rgba(0, 0, 0, 0.8)), url('https://i.ibb.co.com/wF8tS32F/IMG-20260120-WA0191.jpg') no-repeat center center fixed;
            background-size: cover;
            color: #fff;
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Navbar Kaca */
        .navbar-custom {
            background: rgba(0, 0, 0, 0.5);
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            padding: 15px 20px;
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .brand-text {
            font-weight: 700;
            font-size: 1.2rem;
            color: #fff;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .brand-text span {
            color: #38ef7d;
        }

        /* Container Utama */
        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding-top: 80px; /* Space for fixed navbar */
            padding-bottom: 50px;
        }

        /* Card Glassmorphism */
        .glass-card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(15px);
            -webkit-backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.1);
            border-radius: 20px;
            padding: 40px;
            width: 100%;
            max-width: 600px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.5);
            text-align: center;
            position: relative;
            z-index: 10;
        }

        h2 {
            font-weight: 600;
            margin-bottom: 30px;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: #fff;
            text-shadow: 0 0 10px rgba(56, 239, 125, 0.5);
        }

        /* Input Group Styling */
        .custom-input-group {
            position: relative;
            margin-bottom: 20px;
            text-align: left;
        }

        .input-label {
            font-size: 0.85rem;
            color: #bbb;
            margin-bottom: 5px;
            display: block;
            margin-left: 5px;
        }

        .form-control-dark {
            background-color: rgba(0, 0, 0, 0.4) !important;
            border: 1px solid rgba(255, 255, 255, 0.2) !important;
            color: #38ef7d !important;
            height: 50px;
            border-radius: 10px 0 0 10px !important;
        }

        .btn-copy {
            background: #38ef7d;
            color: #000;
            border: none;
            font-weight: bold;
            border-radius: 0 10px 10px 0 !important;
            padding: 0 20px;
            transition: 0.3s;
        }
        .btn-copy:hover {
            background: #2ecc71;
            color: #fff;
        }

        /* Tombol Link Standar */
        .btn-link-panel {
            display: block;
            width: 100%;
            padding: 12px;
            margin-top: 15px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: #fff;
            border-radius: 30px;
            text-decoration: none;
            transition: 0.3s;
        }
        .btn-link-panel:hover {
            background: rgba(255, 255, 255, 0.2);
            color: #fff;
            text-decoration: none;
        }

        /* Tombol Utama (Buka Panel) */
        .btn-main {
            display: block;
            width: 100%;
            padding: 14px;
            margin-top: 25px;
            background: linear-gradient(45deg, #11998e, #38ef7d);
            border: none;
            border-radius: 30px;
            color: #fff;
            font-weight: bold;
            text-transform: uppercase;
            letter-spacing: 1px;
            text-decoration: none;
            box-shadow: 0 4px 15px rgba(56, 239, 125, 0.4);
            transition: 0.3s;
        }
        .btn-main:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(56, 239, 125, 0.6);
            color: #fff;
            text-decoration: none;
        }

        /* Floating Logo Animation (Asli Punya Kamu) */
        .floating-logo {
            position: fixed; /* Changed to fixed to float over everything */
            top: 50%; 
            animation: floatLogo 8s linear infinite;
            animation-direction: alternate; 
            width: 100px;
            opacity: 0.6;
            z-index: 1; /* Behind the card */
            pointer-events: none;
        }
        @keyframes floatLogo {
            0% { left: 100%; }
            100% { left: -10%; }
        }
    </style>
</head>
<body>

    <nav class="navbar-custom">
        <div class="brand-text">
            <i class="fas fa-shield-alt mr-2"></i>Mangkezy <span>Jasteb</span>
        </div>
    </nav>

    <div class="main-container">
        <div class="glass-card">
            <h2><i class="fas fa-check-circle text-success mr-2"></i>Panel Siap!</h2>
            
            <?php
            if (isset($_GET['web'])) {
                $web = htmlspecialchars($_GET['web']);

                // URL Variables
                $apiUrl = "https://{$_SERVER['HTTP_HOST']}/{$web}/apiii.php";
                $settingUrl = "https://{$_SERVER['HTTP_HOST']}/{$web}/kezy";

                // 1. API SECTION (Dengan Tombol Copy)
                echo '<div class="custom-input-group">';
                echo '<label class="input-label"><i class="fas fa-link mr-1"></i> Link API (Wajib Disalin)</label>';
                echo '<div class="input-group">';
                echo '<input type="text" class="form-control form-control-dark" value="'.$apiUrl.'" id="apiInput" readonly>';
                echo '<div class="input-group-append">';
                echo '<button class="btn btn-copy" onclick="copyToClipboard()"><i class="fas fa-copy"></i> SALIN</button>';
                echo '</div>';
                echo '</div>';
                echo '</div>';

                // 2. SETTING URL
                echo '<div class="custom-input-group">';
                echo '<label class="input-label"><i class="fas fa-cogs mr-1"></i> Link Settings</label>';
                echo '<input type="text" class="form-control" style="background: rgba(0,0,0,0.3); border:1px solid #444; color:#aaa; border-radius:10px;" value="'.$settingUrl.'" readonly>';
                echo '</div>';
                
                // 3. BUTTONS
                echo '<a href="'.$settingUrl.'" class="btn-main"><i class="fas fa-rocket mr-2"></i> BUKA PANEL SEKARANG</a>';
                
            } else {
                echo "<div class='alert alert-danger'>Error: Direktori Web tidak ditemukan.</div>";
            }
            ?>
            
        </div>
    </div>

    <div id="floatingLogos">
        <img src="img/1.png" alt="Logo 1" class="floating-logo" style="animation-duration: 10s; left: 100%; top: 20%;">
        <img src="img/21.png" alt="Logo 2" class="floating-logo" style="animation-duration: 8s; left: 100%; top: 70%;">
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    
    <script>
        // Fitur Copy ke Clipboard
        function copyToClipboard() {
            var copyText = document.getElementById("apiInput");
            copyText.select();
            copyText.setSelectionRange(0, 99999); /* Untuk mobile */
            document.execCommand("copy");

            Swal.fire({
                icon: 'success',
                title: 'Berhasil Disalin!',
                text: 'Link API sudah dicopy ke clipboard.',
                background: '#1a1a1a',
                timer: 1500,
                showConfirmButton: false,
                customClass: {
                    title: 'text-white',
                    content: 'text-white'
                }
            });
        }

        // Script Animasi Logo (Asli)
        document.addEventListener('DOMContentLoaded', function() {
            const floatingLogos = document.querySelectorAll('.floating-logo');
            const bodyWidth = document.body.clientWidth;

            floatingLogos.forEach((logo, index) => {
                const animationDuration = parseInt(logo.style.animationDuration) * 1000;
                const startDelay = index * 1000;

                setTimeout(() => {
                    logo.style.left = bodyWidth + 'px';
                    logo.style.animationDelay = startDelay + 'ms';
                }, 0);

                // Reset position loop handled by CSS animation keyframes mostly, 
                // but kept existing logic structure just in case.
                setTimeout(() => {
                    logo.style.left = '-' + logo.clientWidth + 'px';
                }, startDelay);
            });
        });
    </script>
</body>
</html>
